set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3411',
      '21224211',
      NULL,
      NULL,
      '1420303',
      23.615627,
      NULL,
      3.406228,
      1,
      '122234',
      2.951922,
      NULL,
      39,
      21,
      1.000690,
      NULL,
      0,
      0,
      2.747341,
      0,
      0,
      0.729387,
      0,
      NULL,
      0,
      0,
      5.194629,
      NULL,
      0.404102,
      1.495881,
      1,
      0.045746,
      2.656731,
      1.002981,
      1,
      NULL,
      0,
      0,
      4.435216,
      NULL,
      NULL,
      3,
      2,
      0.097808,
      NULL,
      NULL,
      1.043562,
      NULL,
      NULL,
      0,
      0.359032,
      1.246257,
      0.012287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929529,
      0.995196,
      1.122115,
      1.695522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850358,
      2.296694,
      0,
      0.641864,
      1.920265,
      4.371343,
      6,
      3,
      NULL,
      1.392310,
      2,
      NULL,
      0,
      4.733241,
      1,
      1,
      NULL,
      0.809845,
      1.139206,
      NULL,
      NULL,
      1,
      2.091693,
      1,
      1,
      NULL,
      5.366163,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      6.658513,
      7,
      NULL,
      NULL,
      6.275703,
      6,
      0.542656,
      7.563095,
      2,
      3.032672,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.031716,
      0,
      0,
      1.894620,
      1.302072,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.828713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.943298,
      NULL,
      1.542793,
      0,
      1.653383,
      NULL,
      NULL,
      NULL,
      NULL,
      5.997680,
      0.325412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134266,
      0,
      0,
      0,
      0.271583,
      NULL,
      1.676779,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.556245,
      1.845418,
      0.902730,
      NULL,
      0.341363,
      NULL,
      0.558681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.505412,
      '12344',
      '',
      NULL,
      0.220010,
      '',
      NULL,
      '',
      NULL,
      '3044',
      '1224',
      '',
      5.637280,
      2,
      NULL,
      1,
      2,
      1.486383,
      NULL,
      2.352566,
      2.625563);
commit;
end;
/


