set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      70,
      50.762711,
      NULL,
      13,
      1,
      3,
      NULL,
      '211123',
      4,
      '11- 9-1985',
      34.945872,
      1,
      1.969877,
      NULL,
      2.705321,
      1,
      NULL,
      0.253094,
      0.000028,
      0,
      0,
      0,
      0,
      0,
      4,
      0,
      0,
      4.670623,
      1,
      NULL,
      0,
      0,
      0.108477,
      2.659041,
      7.563867,
      1.661129,
      5.506789,
      NULL,
      1,
      2,
      NULL,
      1.904160,
      NULL,
      NULL,
      0.914957,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1,
      1.549664,
      NULL,
      3.910467,
      NULL,
      2.006720,
      0.098888,
      0.832694,
      0.254261,
      0,
      3,
      0.439720,
      3.803846,
      NULL,
      3.891909,
      NULL,
      0.798592,
      3.821365,
      2.602303,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.190691,
      1.350906,
      1,
      NULL,
      0,
      1,
      0.128992,
      1.417893,
      1.974138,
      NULL,
      0.831298,
      1.218142,
      1,
      NULL,
      1,
      0.926474,
      1.432510,
      0.349887,
      NULL,
      NULL,
      1,
      1,
      1.454018,
      1.422006,
      1.034482,
      NULL,
      NULL,
      NULL,
      1,
      4.023278,
      NULL,
      0.009906,
      1,
      2,
      1,
      0.004510,
      NULL,
      4.673819,
      NULL,
      5,
      3.565283,
      NULL,
      0,
      2.002398,
      1.183163,
      1,
      0.475826,
      2,
      NULL,
      NULL,
      5,
      0.077914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.887231,
      1,
      NULL,
      1.885226,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.227954,
      NULL,
      5,
      0,
      0,
      0,
      NULL,
      1.197416,
      NULL,
      NULL,
      5.770331,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      3.999120,
      0.034462,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.568134,
      NULL,
      0,
      3,
      1.412818,
      0,
      0.375747,
      1,
      0.921171,
      1,
      0.160472,
      1,
      1.736341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.988240,
      NULL,
      '02401',
      '',
      0.289328,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      5,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.050530,
      NULL,
      1.405465);
commit;
end;
/


