set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00314311',
      13.841837,
      50,
      '1331012',
      22.830720,
      5,
      1.028858,
      0,
      '024100',
      NULL,
      ' 5-18-2002',
      14,
      52,
      1,
      NULL,
      1.890088,
      0,
      1.330946,
      NULL,
      3,
      0.986252,
      NULL,
      1.762163,
      3.994579,
      NULL,
      5,
      0,
      0.996425,
      0,
      NULL,
      NULL,
      2.393554,
      0.280945,
      1.767899,
      1.069758,
      0.242121,
      NULL,
      5,
      1,
      NULL,
      0.784928,
      3.411753,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.579287,
      1.568871,
      1,
      NULL,
      NULL,
      1.949925,
      1,
      0.950103,
      2.504218,
      1,
      2.469644,
      2,
      0,
      1,
      2,
      1.735005,
      1,
      1.151853,
      0,
      5,
      1,
      0,
      NULL,
      0.968771,
      NULL,
      NULL,
      0.581950,
      NULL,
      NULL,
      1,
      1,
      1.082892,
      0,
      0.407976,
      1.753898,
      0,
      0,
      1.666161,
      1.634101,
      0,
      0,
      0,
      NULL,
      0.598093,
      1.386205,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.953435,
      0.398413,
      NULL,
      0.574145,
      0.980911,
      NULL,
      0.144401,
      4,
      1,
      5.204983,
      1,
      0,
      1.717357,
      1,
      1,
      1,
      2.446089,
      NULL,
      3.504101,
      NULL,
      4,
      5.471425,
      3.811766,
      2,
      1.441855,
      NULL,
      0,
      0,
      NULL,
      0.332064,
      5,
      0.535057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194908,
      0.511184,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.497817,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.500391,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.376705,
      NULL,
      1.267665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.388543,
      3,
      0,
      0.921979,
      1,
      NULL,
      0,
      1.482849,
      NULL,
      1,
      1.330162,
      1,
      0.394903,
      1.933050,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901496,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664299,
      NULL,
      1.869474,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      '40220',
      '00231',
      NULL,
      0.610267,
      '',
      '',
      NULL,
      1.595124,
      '',
      NULL,
      '',
      3.953142,
      0,
      0,
      1,
      2,
      2,
      NULL,
      0,
      1.811473);
commit;
end;
/


