set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '42441413',
      48.462299,
      2,
      '3312331',
      34,
      2,
      2.837982,
      2,
      '042112',
      2,
      NULL,
      24,
      51,
      1.948408,
      NULL,
      5,
      3,
      1,
      1,
      0.878680,
      NULL,
      3.026812,
      1,
      NULL,
      1,
      0,
      1.702563,
      1.080268,
      NULL,
      NULL,
      0,
      2.714320,
      1.577862,
      0,
      1.275237,
      4,
      NULL,
      5,
      0,
      NULL,
      0,
      0,
      1.650425,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.681997,
      4,
      1.861192,
      1.394921,
      NULL,
      3.301406,
      0.284422,
      0,
      0.908759,
      1,
      0,
      2,
      1,
      0,
      1,
      0,
      1.764314,
      0,
      NULL,
      4,
      7.592715,
      4,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      1.910370,
      NULL,
      NULL,
      1.083946,
      0.126709,
      1,
      0,
      5,
      0.364277,
      1,
      1.926229,
      1,
      0.227822,
      1,
      0,
      0,
      0.502717,
      1.300538,
      0.332846,
      NULL,
      1.479198,
      0.177462,
      NULL,
      NULL,
      1,
      NULL,
      1.920302,
      1,
      1,
      0,
      1,
      7,
      0,
      0.340084,
      1,
      4.191520,
      0,
      3.742465,
      5,
      1,
      9.861285,
      NULL,
      0.470565,
      NULL,
      0.016937,
      2,
      6,
      1.296343,
      2,
      2,
      NULL,
      3,
      0.590036,
      1.872444,
      0.621548,
      1.947297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.720153,
      1,
      1,
      1,
      1.950601,
      0.269009,
      0.024237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.788767,
      2,
      2,
      0.209467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.845171,
      1.928956,
      NULL,
      NULL,
      NULL,
      2,
      1.043697,
      4,
      1,
      NULL,
      2,
      4.527816,
      1.034098,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756507,
      1.670318,
      2,
      0,
      2,
      NULL,
      NULL,
      3,
      1.943385,
      1,
      0,
      1,
      NULL,
      1,
      1.463311,
      0,
      NULL,
      0.633098,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.996120,
      '23111',
      '00324',
      '',
      0.367731,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      4.266311,
      NULL,
      5,
      5,
      2,
      NULL,
      1.258300,
      NULL);
commit;
end;
/


