set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1442',
      '04421223',
      77.711716,
      2,
      '3220433',
      71.607231,
      6,
      2,
      3,
      '332122',
      0,
      NULL,
      NULL,
      36,
      0.705398,
      NULL,
      0.819417,
      NULL,
      0,
      NULL,
      1.387060,
      1.389489,
      NULL,
      0,
      NULL,
      0.353987,
      2,
      0,
      1.908378,
      NULL,
      NULL,
      0,
      6.202556,
      3,
      4.150471,
      0,
      NULL,
      1,
      4.440682,
      0,
      4,
      0,
      2.952599,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.751068,
      0,
      NULL,
      1.258486,
      3.879943,
      0.553225,
      0,
      2,
      0.095426,
      NULL,
      NULL,
      2.888863,
      NULL,
      0.307016,
      2.117272,
      1,
      0,
      7,
      1.544340,
      1.198143,
      NULL,
      3,
      2,
      NULL,
      0.722045,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.490177,
      0.790533,
      NULL,
      1,
      1,
      3,
      4,
      1,
      1.090796,
      1,
      1,
      NULL,
      1,
      2.581570,
      1.523750,
      NULL,
      0,
      0,
      1,
      NULL,
      1.752661,
      1,
      0.627343,
      0,
      1,
      NULL,
      1.457430,
      1.476609,
      5,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.896676,
      NULL,
      1.072435,
      0,
      5,
      2,
      2,
      3,
      1,
      1.129614,
      4.513269,
      1,
      1,
      2.255445,
      0,
      0,
      1.703256,
      0.450857,
      0.057629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524386,
      1.690894,
      1,
      1,
      1,
      NULL,
      0.611756,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109825,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050559,
      1.868788,
      NULL,
      NULL,
      NULL,
      1.822967,
      1,
      0.247509,
      2.755226,
      1,
      2,
      1.812825,
      NULL,
      NULL,
      NULL,
      1.408243,
      1,
      1.418560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.588521,
      NULL,
      0.408030,
      NULL,
      1.781444,
      NULL,
      NULL,
      0.263121,
      0.188392,
      0,
      0.471164,
      1.008886,
      1.950162,
      0,
      0.714953,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '31414',
      '44103',
      '',
      1.772857,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      2,
      0.062795,
      NULL);
commit;
end;
/


