set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4140',
      '42304221',
      48.776302,
      49,
      '2343401',
      81.484799,
      0,
      2,
      NULL,
      NULL,
      4.275855,
      ' 5- 4-1990',
      7,
      20,
      0,
      NULL,
      2.072367,
      NULL,
      1.240593,
      1,
      0,
      2.977952,
      NULL,
      1,
      2,
      0,
      4.159660,
      0,
      0,
      1.971718,
      0,
      0,
      6,
      1.734955,
      1,
      2,
      9,
      0.416289,
      9.238208,
      0,
      4.573089,
      2,
      0.580796,
      0.678829,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.219107,
      3,
      3,
      2,
      NULL,
      2,
      3,
      0,
      NULL,
      0.004071,
      1.981117,
      0,
      3.397804,
      1.056591,
      0.581018,
      2.501967,
      3.085745,
      NULL,
      0.477354,
      7.082881,
      6,
      0.332866,
      7,
      0,
      1,
      0.934293,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.251789,
      0.285144,
      1.960174,
      0.339375,
      NULL,
      1,
      0.274681,
      NULL,
      0,
      0.415411,
      1,
      1.089826,
      0,
      NULL,
      0,
      1.711019,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.320293,
      1.952081,
      NULL,
      0,
      0.907604,
      0,
      1.347838,
      1.327693,
      5,
      1,
      2,
      0,
      NULL,
      5.015947,
      2,
      6,
      2.342921,
      7,
      NULL,
      5,
      NULL,
      0,
      1,
      2.488458,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.968930,
      NULL,
      1,
      0.621821,
      1,
      1.877307,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719331,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.608214,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430639,
      1,
      NULL,
      2.651089,
      1,
      1.518308,
      NULL,
      NULL,
      NULL,
      1.649292,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.645051,
      0,
      0.365185,
      0,
      0.788774,
      3,
      1.553779,
      1.203436,
      2.005709,
      NULL,
      1,
      1,
      1.047246,
      NULL,
      1.726945,
      NULL,
      1.073426,
      0.655997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.601952,
      '42300',
      NULL,
      '',
      0.390269,
      '',
      NULL,
      '',
      0.676592,
      '',
      '',
      NULL,
      1.088738,
      3.231550,
      NULL,
      3.802497,
      NULL,
      0,
      0,
      NULL,
      2);
commit;
end;
/


