set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01',
      25.674775,
      0.309505,
      '2443410',
      3,
      3,
      3,
      NULL,
      '012433',
      3,
      ' 4-25-1994',
      16.116460,
      37,
      0.853983,
      NULL,
      1.915870,
      3.449057,
      NULL,
      0,
      0.715770,
      1.997361,
      2.076426,
      0.967706,
      0.328830,
      0.535791,
      9,
      1.863826,
      0.422448,
      0.525714,
      1,
      1,
      1,
      1.143663,
      1,
      0,
      1,
      0,
      7,
      0,
      NULL,
      1,
      1.460483,
      0,
      NULL,
      NULL,
      0.389718,
      NULL,
      NULL,
      1.888049,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.257190,
      0.475376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224574,
      1.571823,
      0.079063,
      NULL,
      1,
      0.271131,
      NULL,
      0.456506,
      NULL,
      1.072306,
      0.412557,
      1,
      0.916282,
      0.375064,
      NULL,
      NULL,
      0.581217,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.627858,
      NULL,
      NULL,
      0.260484,
      1,
      0,
      1.700724,
      1,
      1,
      1,
      NULL,
      NULL,
      5.295551,
      NULL,
      7,
      1,
      4,
      NULL,
      7.597154,
      7.504409,
      7,
      2,
      NULL,
      1,
      1,
      1.533736,
      1,
      3,
      0.702260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0.276640,
      1.494306,
      1.206848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390940,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274772,
      3.870389,
      3.609994,
      NULL,
      NULL,
      3,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.782883,
      5.468405,
      0.304863,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178598,
      1,
      1.518725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179976,
      2.277974,
      1.539860,
      0.805847,
      0.866546,
      3,
      2.108822,
      0.435189,
      3,
      1.477359,
      0.156413,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.464696,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      3,
      '1411',
      '2041',
      '',
      1.039397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


