set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '24',
      30.864754,
      27,
      '0342342',
      27.637799,
      2,
      2,
      1,
      '141120',
      NULL,
      ' 3-25-1974',
      55,
      32.394542,
      NULL,
      NULL,
      NULL,
      1.167051,
      1,
      0.713764,
      1,
      1,
      1.350529,
      1.446067,
      NULL,
      1,
      7,
      0.957206,
      NULL,
      1,
      NULL,
      1.832565,
      0.435380,
      1.021620,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      5.227394,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.118183,
      0,
      0.517659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.499108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.993506,
      NULL,
      1.230818,
      0.432103,
      1.603759,
      1.153053,
      1,
      1,
      0,
      1.559554,
      0,
      NULL,
      0.745962,
      0.028707,
      1.383513,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.003061,
      1,
      0.055336,
      1,
      0.046659,
      NULL,
      1,
      1,
      NULL,
      2,
      6,
      3,
      1.271004,
      NULL,
      0.927523,
      9.634390,
      1,
      1,
      1.048216,
      NULL,
      1.464489,
      1.321549,
      NULL,
      0.989016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846936,
      1.036041,
      0,
      1,
      NULL,
      1.049211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      1.413689,
      1,
      1.694798,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.573930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.462165,
      NULL,
      0.723436,
      3,
      0.897022,
      1.530745,
      2.203464,
      NULL,
      2,
      1,
      1.368118,
      NULL,
      1,
      0.547517,
      1,
      0,
      1,
      0.529434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.464893,
      '31421',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      2,
      NULL,
      3,
      0,
      0.718529,
      2,
      NULL,
      NULL);
commit;
end;
/


