set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11413413',
      NULL,
      34,
      '4134242',
      35,
      3,
      0,
      3,
      '321133',
      2,
      ' 9-28-1992',
      4,
      14,
      NULL,
      NULL,
      0,
      1,
      0.829307,
      0.815060,
      0.943276,
      1,
      NULL,
      0.456631,
      0.417812,
      0,
      NULL,
      0.669504,
      1,
      NULL,
      0.240189,
      0.769174,
      0.257510,
      0.180432,
      1.849767,
      0.628604,
      0.971014,
      NULL,
      5,
      0,
      2,
      1,
      0.828097,
      1.480196,
      NULL,
      NULL,
      0.683217,
      NULL,
      NULL,
      NULL,
      1.825498,
      1.949959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518113,
      1,
      0.038057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.077097,
      1.963065,
      1,
      NULL,
      0.499628,
      1.252169,
      1,
      1,
      0.255680,
      0.400401,
      0,
      NULL,
      0.954167,
      0,
      NULL,
      0,
      0.721675,
      NULL,
      0.557675,
      NULL,
      0,
      1.773381,
      0.551572,
      0,
      0,
      1,
      1.917683,
      NULL,
      3,
      7,
      NULL,
      1,
      0.373016,
      1.939769,
      0,
      3.177997,
      0.975373,
      4.687715,
      0.421759,
      NULL,
      4,
      0.860908,
      NULL,
      5.412087,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8,
      1.291351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924130,
      NULL,
      NULL,
      NULL,
      1.485474,
      NULL,
      1.141847,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.260684,
      1,
      1,
      5,
      2,
      NULL,
      1,
      NULL,
      NULL,
      8.634661,
      0,
      0.627748,
      NULL,
      NULL,
      NULL,
      1.761843,
      5.501888,
      1.638409,
      0.999370,
      0.659622,
      0,
      2.349069,
      NULL,
      NULL,
      NULL,
      1,
      2.549002,
      1.454248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.650442,
      NULL,
      3,
      1.565200,
      1,
      1.932719,
      1,
      2,
      0.864787,
      3.094866,
      1.864414,
      0,
      0,
      1.075017,
      NULL,
      1.008631,
      1.405210,
      0.917252,
      1.098153,
      2,
      1.122913,
      1,
      NULL,
      0,
      0.041838,
      0,
      1.303808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '21101',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '3123',
      '0013',
      '34203',
      1.637885,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      3.564760,
      3);
commit;
end;
/


