set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '30011040',
      28.655923,
      76.250228,
      '3103133',
      28.645170,
      3,
      2,
      NULL,
      '103303',
      4,
      '10- 7-1982',
      22,
      NULL,
      NULL,
      NULL,
      1,
      3.167735,
      0,
      1.001504,
      0,
      NULL,
      3.590669,
      1.849146,
      1.042155,
      1,
      1.144825,
      1.374329,
      6.950943,
      NULL,
      0,
      0.722108,
      7,
      1.081298,
      1,
      NULL,
      0,
      NULL,
      0.492456,
      0,
      NULL,
      0,
      1,
      1.155074,
      NULL,
      NULL,
      0,
      NULL,
      2.106769,
      1,
      0.568983,
      1,
      1.243128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484466,
      0.922748,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958032,
      NULL,
      0.372706,
      1.314548,
      1,
      0.523737,
      0.664258,
      0.402486,
      NULL,
      0.136805,
      1,
      NULL,
      NULL,
      0.648535,
      1,
      1.214495,
      0,
      0.325745,
      0.981602,
      NULL,
      0.021906,
      NULL,
      NULL,
      NULL,
      0.400701,
      1,
      NULL,
      1.324478,
      7.289215,
      1,
      NULL,
      4.928477,
      10.602441,
      NULL,
      0.656396,
      0.588921,
      2,
      7,
      6,
      8.260262,
      7,
      3.568447,
      0.180880,
      1,
      3.720743,
      5.940862,
      1,
      4,
      0.302648,
      1,
      0.714880,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.691602,
      1,
      1,
      0.269668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.504846,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10,
      8,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.260116,
      8,
      1.594958,
      NULL,
      0,
      NULL,
      3,
      0.504699,
      1,
      NULL,
      0.937078,
      1,
      0,
      0.443113,
      1.093410,
      0,
      3,
      0.255321,
      2,
      0.740515,
      0,
      0.489470,
      0.228526,
      NULL,
      1.248029,
      0.013648,
      1.579008,
      0.179417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '41240',
      '12222',
      NULL,
      1.356003,
      '',
      '',
      '',
      5.959147,
      '3033',
      '4210',
      '03424',
      5,
      NULL,
      3.692107,
      NULL,
      2,
      0,
      0.789302,
      1,
      2.739715);
commit;
end;
/


