set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '14444213',
      NULL,
      58.629444,
      NULL,
      83.120906,
      6,
      3.594650,
      1,
      '141333',
      3.557930,
      ' 3- 2-1979',
      46.794207,
      14,
      0.947787,
      NULL,
      0.889818,
      NULL,
      1,
      0.498866,
      1,
      1,
      0,
      1.547084,
      1.109104,
      0,
      1.910943,
      1,
      2.948253,
      3,
      NULL,
      0.150160,
      4,
      1,
      0.235865,
      1,
      0.494437,
      NULL,
      2.775912,
      0,
      4,
      4,
      0.625967,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.672767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243538,
      4,
      0.246876,
      NULL,
      NULL,
      1,
      NULL,
      0.637733,
      1,
      1.180844,
      0.483632,
      0,
      0.777474,
      1.491015,
      NULL,
      0.402345,
      1.145020,
      1.962731,
      1.773831,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.093223,
      0.964371,
      0.554085,
      6.100085,
      6,
      4,
      2.363599,
      4.704849,
      NULL,
      0,
      1.927730,
      2,
      2,
      3.983754,
      5,
      7.682182,
      NULL,
      11,
      8,
      NULL,
      1.280243,
      NULL,
      2,
      0.295139,
      NULL,
      2.274497,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703967,
      1,
      0,
      0,
      0.810471,
      NULL,
      3.205765,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.434785,
      0.695160,
      1.872850,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.756807,
      1.941861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727754,
      0,
      0.666783,
      1.448119,
      1.399915,
      0,
      0,
      3.763797,
      0,
      NULL,
      3,
      1.598111,
      1.284800,
      1,
      1.195896,
      1.010576,
      1.365034,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.161005,
      '12123',
      '43234',
      '',
      NULL,
      '',
      NULL,
      '',
      7.017860,
      '0443',
      NULL,
      '01404',
      5.467296,
      6.514797,
      NULL,
      3,
      NULL,
      3,
      3.194244,
      0,
      1);
commit;
end;
/


