set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1031',
      '22441214',
      8.890564,
      61,
      '1203014',
      34,
      2,
      3,
      NULL,
      '032113',
      0.654363,
      ' 5- 1-1986',
      43.733022,
      NULL,
      0.829159,
      NULL,
      0.074989,
      1.795787,
      1.711480,
      0.084628,
      0,
      0,
      0.963781,
      1,
      0,
      NULL,
      4,
      0.003709,
      1,
      0.237165,
      1.783778,
      0,
      1.160765,
      1.857522,
      NULL,
      0.924637,
      1.452031,
      1.119978,
      5,
      1,
      NULL,
      1.873295,
      NULL,
      1.914232,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883297,
      0,
      0,
      1.898955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      0.093516,
      NULL,
      1.395832,
      NULL,
      0.570397,
      1,
      0,
      1.326638,
      0,
      1,
      1,
      1.072348,
      1.558513,
      1,
      NULL,
      0,
      0.638876,
      1.616464,
      NULL,
      1,
      0,
      NULL,
      0.087132,
      2,
      0,
      5,
      0.554382,
      NULL,
      NULL,
      2,
      1.798028,
      NULL,
      7,
      1,
      5,
      1.358453,
      6.992525,
      6.516199,
      1,
      2.857629,
      4,
      0.070265,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0.012684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968760,
      NULL,
      1,
      0,
      0.340178,
      1,
      0.593562,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664224,
      1.953019,
      NULL,
      0,
      0.991576,
      4.370042,
      NULL,
      1.356288,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.974181,
      5,
      NULL,
      0,
      2,
      1.337676,
      NULL,
      NULL,
      NULL,
      1,
      4.788296,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508737,
      NULL,
      1,
      0,
      NULL,
      0.546086,
      2,
      0.427286,
      3,
      0,
      0.570020,
      0.288853,
      1,
      0,
      0.336913,
      1,
      1,
      1.565751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '03300',
      '03210',
      '',
      0.766547,
      '',
      NULL,
      '',
      3,
      '2440',
      NULL,
      '',
      4.397659,
      1,
      2,
      5.641045,
      3.586533,
      1,
      0.914924,
      3.782134,
      0.564887);
commit;
end;
/


