set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '24230230',
      NULL,
      67,
      NULL,
      86,
      6,
      0,
      NULL,
      '044122',
      1.536824,
      ' 4- 0-1974',
      48.120471,
      19.383370,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.249847,
      1,
      0.543583,
      3,
      1,
      NULL,
      NULL,
      0.791659,
      0,
      NULL,
      1.762312,
      1.170312,
      0,
      1,
      1.116924,
      2,
      NULL,
      2.446850,
      1,
      NULL,
      1.017146,
      NULL,
      NULL,
      0.341986,
      NULL,
      NULL,
      0.448570,
      0.276886,
      1.705920,
      0.320514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842928,
      0,
      1.942799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.828327,
      1,
      NULL,
      1.065364,
      1,
      1,
      1.258391,
      1,
      NULL,
      1.456865,
      1,
      0.180464,
      1.895630,
      1,
      1.589766,
      1,
      0.311720,
      NULL,
      NULL,
      1,
      1,
      0.428370,
      0,
      1.243676,
      0.995310,
      1.194682,
      0,
      2,
      2,
      NULL,
      1,
      3,
      1.531222,
      NULL,
      NULL,
      1,
      NULL,
      4.925151,
      4,
      9.979710,
      0,
      2.336976,
      1,
      NULL,
      1.911966,
      1,
      1,
      1,
      NULL,
      NULL,
      4.671305,
      1.964573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      1,
      1,
      3,
      5.317080,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.421259,
      0,
      0,
      0.533529,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.599620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.352923,
      2,
      0.334223,
      NULL,
      1.064424,
      0.111487,
      NULL,
      1,
      0,
      1,
      0,
      1.079817,
      1.943218,
      NULL,
      0.286564,
      NULL,
      0.201482,
      0.651294,
      0.603980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.732956,
      '33040',
      '31002',
      '',
      1,
      '',
      '',
      '',
      0.904976,
      '4010',
      '3223',
      '3242',
      NULL,
      3.495363,
      1.524290,
      3,
      2,
      0,
      3,
      1.652678,
      NULL);
commit;
end;
/


