set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '41320014',
      12,
      16,
      '0144013',
      NULL,
      0,
      NULL,
      3,
      '023321',
      3.395832,
      NULL,
      11,
      38,
      1,
      NULL,
      1.775488,
      1,
      1.568931,
      0.559526,
      NULL,
      1.790143,
      2.322190,
      NULL,
      0.521856,
      1.879284,
      2,
      1.837808,
      0.474400,
      1,
      NULL,
      1.678051,
      0,
      NULL,
      0.720069,
      1,
      0,
      0,
      2.752376,
      1,
      1.826170,
      1.770029,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.370716,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248458,
      0,
      0.737098,
      0,
      0,
      1.644007,
      0.087520,
      0,
      0.744486,
      1.834216,
      1,
      NULL,
      0.366496,
      1,
      0,
      0.063090,
      NULL,
      0.962923,
      1,
      NULL,
      NULL,
      1.331552,
      1.277978,
      0,
      0,
      NULL,
      0.114598,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.805905,
      4.793430,
      1.469505,
      1.982643,
      1,
      NULL,
      NULL,
      4.645877,
      6.078153,
      NULL,
      1.329752,
      NULL,
      1,
      0.073731,
      1,
      0.641796,
      1.984755,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565318,
      0,
      1,
      NULL,
      1,
      0.182596,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460019,
      NULL,
      3.538941,
      NULL,
      1.229127,
      1.829136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.745474,
      1.186306,
      4,
      3,
      1,
      1.606327,
      NULL,
      NULL,
      NULL,
      0.944738,
      1,
      0.292893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133574,
      0,
      0.509242,
      0,
      0.125768,
      1.136913,
      1.079361,
      2.479276,
      1.741116,
      1,
      2.330528,
      1,
      0.518166,
      0.314313,
      0,
      0.072060,
      1,
      0.581331,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.241516,
      '04314',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.423344,
      '',
      '',
      '',
      NULL,
      2,
      1.546194,
      NULL,
      1.270628,
      1,
      1.818162,
      0.102093,
      1.241992);
commit;
end;
/


