set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '41011013',
      13,
      16,
      '2433103',
      6.790556,
      3,
      3.636903,
      3,
      '241114',
      3.282345,
      ' 3- 5-1994',
      156.607754,
      135.582759,
      0.809158,
      NULL,
      1,
      0.576239,
      2,
      0,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      5.066050,
      1,
      NULL,
      0,
      1,
      NULL,
      6.566362,
      0.872404,
      1,
      1,
      1.392314,
      1,
      3,
      1,
      3.031094,
      0,
      0,
      1.828285,
      NULL,
      NULL,
      0.136976,
      NULL,
      NULL,
      1,
      1.315776,
      0,
      0.295701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991034,
      0.750109,
      1,
      0,
      0.074741,
      NULL,
      0,
      1,
      1.313988,
      NULL,
      0.024523,
      1,
      NULL,
      1,
      0,
      1.796069,
      0,
      0,
      1,
      NULL,
      0.616972,
      1.195088,
      1,
      1,
      0,
      0.045692,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.770422,
      1.517407,
      4.840985,
      1.499789,
      2.863930,
      NULL,
      4.885693,
      2.061384,
      3,
      2,
      NULL,
      0,
      0,
      1,
      0,
      1.240362,
      1,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841691,
      0.276240,
      0,
      NULL,
      0.144371,
      0.321001,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      NULL,
      1.456777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.862272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971095,
      4.280064,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.195940,
      0.133407,
      0.317107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.424730,
      1,
      1,
      2.915295,
      NULL,
      NULL,
      1.065986,
      3.964398,
      NULL,
      0,
      NULL,
      0.769375,
      0.368950,
      1,
      0.107337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '20001',
      '',
      '',
      0.558863,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3,
      2,
      1,
      0.195481,
      1,
      2,
      1.704416,
      3);
commit;
end;
/


