set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '13331312',
      NULL,
      70,
      '1431304',
      51.948984,
      0,
      NULL,
      2,
      '434102',
      3,
      ' 2- 8-2002',
      26,
      27.298069,
      0,
      NULL,
      1.662486,
      0.867171,
      2.070895,
      NULL,
      1,
      1.982888,
      2.471534,
      1.885880,
      1,
      0.385492,
      2,
      NULL,
      1.208077,
      1.522135,
      1,
      1,
      0.712565,
      0,
      1,
      1,
      0.746704,
      1.868749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996591,
      0,
      0.378739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.469358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389631,
      1,
      1.305000,
      NULL,
      NULL,
      1,
      1.202238,
      NULL,
      0.569261,
      0.647419,
      0,
      0.622123,
      NULL,
      NULL,
      1,
      1,
      0.832455,
      0,
      0,
      NULL,
      0.635710,
      1.994847,
      1,
      1.831175,
      0,
      1.150551,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981122,
      0,
      0.061647,
      1.883746,
      1.056429,
      0.396144,
      0,
      NULL,
      4.301246,
      4,
      NULL,
      NULL,
      4.088040,
      1,
      1,
      1.541032,
      1,
      NULL,
      NULL,
      5.284495,
      0.949506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.832362,
      1,
      NULL,
      0,
      0,
      1.269276,
      0.843670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774008,
      0.150892,
      5.000269,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597298,
      1.584308,
      1.086794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711698,
      0,
      1,
      NULL,
      NULL,
      1.127011,
      1.996353,
      1.652925,
      1.416366,
      0,
      1,
      1.853236,
      1,
      1,
      1.288839,
      0.920152,
      1.667123,
      0.463223,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23212',
      '',
      '',
      1.846658,
      '',
      NULL,
      '',
      1.407413,
      '',
      '',
      '',
      1.986797,
      3,
      3.168111,
      0.778925,
      0.879329,
      0.570833,
      3.156211,
      NULL,
      3.724320);
commit;
end;
/


