set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      '11440310',
      69.543711,
      NULL,
      '1033040',
      87,
      3,
      1,
      0,
      '231120',
      0,
      ' 5-27-1978',
      81,
      175,
      0,
      NULL,
      0.788199,
      3.445498,
      NULL,
      1,
      1,
      0.508213,
      3.566761,
      1.853188,
      1.180865,
      0.083135,
      NULL,
      0,
      1,
      1,
      0,
      0.665694,
      1,
      0.367164,
      0.928067,
      0,
      NULL,
      0.087725,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532057,
      1,
      0.421512,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.493022,
      NULL,
      0.501310,
      1.453050,
      NULL,
      1.495017,
      1.305897,
      1,
      1.277751,
      0,
      0.320634,
      NULL,
      NULL,
      0.792478,
      0,
      0.253883,
      0.465438,
      1.244362,
      NULL,
      1.273146,
      1.722613,
      0.929418,
      0,
      1.440500,
      1.553653,
      1,
      0,
      1.656167,
      NULL,
      1.185362,
      1.594232,
      1.996617,
      NULL,
      1.979268,
      1.603941,
      NULL,
      0.585186,
      1.658914,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.723673,
      0.982389,
      1.778530,
      0.620917,
      0.978135,
      NULL,
      NULL,
      3.285981,
      0.452007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718279,
      1.226809,
      NULL,
      1,
      0.716614,
      NULL,
      1.822022,
      1.442842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235498,
      0.212272,
      0.953479,
      2.455460,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.077716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737462,
      3,
      1.306017,
      1,
      1,
      0,
      1.570070,
      0.530636,
      1.767062,
      1,
      1.909987,
      0,
      NULL,
      1,
      0,
      NULL,
      0.058497,
      1.690513,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      0.753935,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.929659,
      0,
      1,
      NULL,
      2.640278,
      2.115145,
      1,
      3,
      2);
commit;
end;
/


