set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130',
      NULL,
      23,
      36.765496,
      '3321131',
      113.124470,
      1,
      3,
      0,
      '123403',
      2.256527,
      ' 8- 7-1993',
      21,
      48,
      NULL,
      NULL,
      0.037546,
      NULL,
      NULL,
      0.505445,
      0,
      0,
      0,
      3.789895,
      1,
      1,
      NULL,
      0.657257,
      0.138160,
      0.282492,
      0.579251,
      NULL,
      5,
      1.177891,
      0.528209,
      1.645218,
      0.420442,
      0.376117,
      1.145555,
      1,
      3,
      3,
      NULL,
      0.387338,
      NULL,
      NULL,
      1.781487,
      NULL,
      NULL,
      0,
      NULL,
      0.287139,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760247,
      1,
      0,
      0.939176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668880,
      1,
      NULL,
      0.743787,
      1,
      1,
      0.107640,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1.009029,
      1.242167,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327239,
      NULL,
      1,
      1,
      0.158435,
      1,
      1,
      0.229795,
      1,
      NULL,
      0.047054,
      0,
      NULL,
      1.042704,
      1.525361,
      1.010236,
      1.143217,
      NULL,
      0.868550,
      1,
      0.730669,
      4,
      3,
      4,
      1,
      0.495065,
      NULL,
      1,
      NULL,
      NULL,
      3.472781,
      1.583509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592675,
      0,
      1,
      1,
      1.097508,
      0,
      1.250226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.687286,
      1,
      2,
      1.982091,
      0.961256,
      1,
      2,
      1,
      0.998971,
      NULL,
      1.793199,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.016906,
      0.972035,
      0.546560,
      0,
      NULL,
      1,
      1.043601,
      1.154901,
      1.312507,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.980782,
      1.702298,
      0.090072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.218112,
      '34041',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '01222',
      '',
      '',
      3.367023,
      0.824416,
      1,
      3.780748,
      2,
      3,
      2.704475,
      3,
      2);
commit;
end;
/


