set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2230',
      '00201322',
      77,
      24,
      '3032333',
      113.007426,
      NULL,
      0,
      NULL,
      '110444',
      0.320766,
      ' 6-21-1976',
      29.371370,
      61,
      1.122742,
      NULL,
      0,
      2.949186,
      1.596972,
      0,
      0,
      0,
      0.116302,
      0,
      0,
      0.069712,
      5.731220,
      0,
      1.310218,
      0,
      1,
      1.015698,
      5,
      0.939988,
      0,
      1.128428,
      0,
      1,
      4,
      1,
      3.008298,
      0.921023,
      0.994496,
      1.782021,
      NULL,
      NULL,
      1.904466,
      NULL,
      NULL,
      0.480603,
      0.352776,
      1.806389,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.545245,
      0.283441,
      NULL,
      0,
      0.316259,
      0.878599,
      1.116319,
      NULL,
      1.929103,
      NULL,
      0,
      1,
      1.572137,
      1.890764,
      0,
      1.471210,
      0.668984,
      0.443995,
      NULL,
      1.854928,
      1,
      0,
      NULL,
      NULL,
      0.626683,
      0.252714,
      NULL,
      2.046510,
      1.664168,
      1,
      NULL,
      1.168632,
      0.544442,
      1.960019,
      NULL,
      1.260798,
      1,
      NULL,
      NULL,
      2.310672,
      NULL,
      0.342424,
      NULL,
      5.794836,
      0,
      0,
      0.311712,
      0.034519,
      NULL,
      NULL,
      2.381314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988831,
      1.895284,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      2,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.490594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.411671,
      1.215523,
      1,
      1,
      1.166497,
      1.677019,
      1,
      NULL,
      0,
      0,
      1.813211,
      1.578636,
      0.365466,
      0,
      0,
      0.480741,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.311844,
      '20213',
      '',
      '',
      1.433041,
      NULL,
      '',
      '',
      NULL,
      '0222',
      '',
      NULL,
      0,
      0.276108,
      2.226879,
      2,
      2.524364,
      0,
      NULL,
      0,
      1.355127);
commit;
end;
/


