set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '2200231',
      6.992515,
      NULL,
      0,
      2,
      '432243',
      NULL,
      ' 9-14-1997',
      14.904868,
      NULL,
      NULL,
      NULL,
      13,
      3.245615,
      0,
      0,
      1,
      0,
      1,
      0,
      1.475489,
      0,
      NULL,
      1.559205,
      1.527836,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0.105931,
      1,
      1.349926,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10,
      9,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.593644,
      NULL,
      3.412931,
      1,
      3,
      1.041556,
      NULL,
      0.334239,
      1.231232,
      1.435554,
      NULL,
      3.727119,
      1.842108,
      1.502967,
      1,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.997446,
      NULL,
      NULL,
      NULL,
      NULL,
      4.626457,
      1,
      4.532754,
      NULL,
      NULL,
      0.566084,
      1.879389,
      1,
      1.126415,
      0.808094,
      0.734738,
      NULL,
      0,
      1.409577,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.561214,
      0,
      0.974637,
      0,
      0,
      4.955722,
      NULL,
      NULL,
      0,
      0.985997,
      1.337378,
      4.227477,
      1,
      NULL,
      5,
      6.450248,
      6.390960,
      1.829957,
      0,
      5.861097,
      2.810173,
      1.607905,
      1,
      1.614587,
      NULL,
      NULL,
      NULL,
      1.253690,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.886693,
      1.279376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448143,
      NULL,
      NULL,
      NULL,
      0.207148,
      3.963311,
      3,
      0,
      0.484215,
      1.371056,
      1,
      6,
      2,
      0.823168,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.701948,
      0,
      1.738205,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.311676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615655,
      0,
      0.216498,
      1.420526,
      3,
      NULL,
      0.544078,
      0.661832,
      0.929273,
      1,
      1.016611,
      0.588977,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.944086,
      1.389512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '',
      0.139280,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


