set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '30',
      22.702956,
      9.930437,
      '4440013',
      37.362528,
      0,
      2.167629,
      0,
      '100013',
      1.569190,
      '10-28-1991',
      29,
      28.249012,
      1,
      NULL,
      NULL,
      2,
      1,
      0.044557,
      NULL,
      1,
      0,
      NULL,
      0,
      0.000110,
      0.490078,
      NULL,
      NULL,
      1,
      1.190839,
      0,
      1.317330,
      NULL,
      0.981607,
      0.046046,
      NULL,
      3.490756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.350627,
      7.550220,
      0,
      2.293738,
      NULL,
      1.219495,
      NULL,
      2.540009,
      2.913066,
      0.929740,
      3,
      NULL,
      2.102926,
      NULL,
      NULL,
      1,
      1.868626,
      2.965008,
      3,
      1,
      1,
      5.439859,
      4,
      1,
      0,
      0.409816,
      1.554743,
      NULL,
      NULL,
      1.410680,
      NULL,
      NULL,
      NULL,
      1.695361,
      NULL,
      1,
      3,
      1,
      1,
      1,
      1,
      1.478588,
      1.035557,
      1.063117,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.866519,
      1.297142,
      0.007403,
      0,
      0.018852,
      3,
      0.981787,
      0,
      NULL,
      2.816491,
      0,
      5.242234,
      1.039297,
      2,
      NULL,
      2.838198,
      4.311298,
      NULL,
      4,
      5,
      3,
      0,
      1,
      1.928626,
      1.418394,
      NULL,
      0.283951,
      1.980473,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496425,
      0,
      1,
      0,
      NULL,
      1.165732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245437,
      1,
      4,
      NULL,
      0.140106,
      2,
      4,
      1.054624,
      NULL,
      NULL,
      NULL,
      1.518052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.506536,
      1,
      1.136495,
      0,
      1,
      NULL,
      0.804060,
      0.701027,
      1,
      1.659521,
      1,
      0,
      NULL,
      0,
      NULL,
      1.988964,
      0.627628,
      0.716413,
      1.140423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.150065,
      '11332',
      '34303',
      '',
      0,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


