set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '34',
      15,
      6,
      NULL,
      2.209987,
      5,
      2.662349,
      3,
      '323143',
      2.627051,
      ' 9-18-2003',
      23.479103,
      43,
      NULL,
      NULL,
      0,
      3.796165,
      0.155824,
      0,
      0,
      1,
      0,
      0.552688,
      NULL,
      0,
      1.383852,
      NULL,
      0.649740,
      0.418334,
      1,
      1,
      1.194065,
      0,
      0,
      0,
      1,
      0.192173,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.141025,
      8,
      NULL,
      3,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.119154,
      NULL,
      0.106923,
      1,
      1.816044,
      1,
      1.997963,
      NULL,
      1.839201,
      0,
      NULL,
      4.677301,
      7,
      NULL,
      1,
      3.934767,
      1.334675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.743211,
      NULL,
      0.629766,
      0.869671,
      1,
      1,
      0,
      0,
      0.988216,
      1.458120,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.796794,
      0,
      NULL,
      NULL,
      0.984138,
      NULL,
      0,
      NULL,
      1.387380,
      1,
      0.174931,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3,
      4.118021,
      4.061466,
      5.605561,
      4.267909,
      1.032420,
      4,
      2.739419,
      3,
      0.028344,
      NULL,
      0.063655,
      2,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.800313,
      NULL,
      NULL,
      1.497160,
      NULL,
      NULL,
      0.910343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014120,
      NULL,
      1.820521,
      2,
      4.250092,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087594,
      0,
      0.153231,
      1.312589,
      1.571251,
      1,
      1,
      1,
      0,
      1.197471,
      1.347112,
      0.802347,
      0,
      NULL,
      1.381014,
      1,
      0,
      0,
      0,
      1.449067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14413',
      NULL,
      NULL,
      1.226194,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.711351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


