set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '33',
      21,
      9,
      NULL,
      0.673372,
      4,
      1.671319,
      3,
      '103101',
      5.586530,
      ' 6-11-1998',
      28.806521,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.502958,
      1.382111,
      NULL,
      1,
      NULL,
      0.275385,
      0.099135,
      1.368567,
      NULL,
      0,
      1.242977,
      0.083370,
      NULL,
      0,
      1.390830,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335112,
      3.043475,
      1,
      0.740226,
      2,
      1.090942,
      1,
      NULL,
      NULL,
      1.139528,
      NULL,
      NULL,
      11.095674,
      1.402826,
      0.930323,
      0,
      1.797442,
      0,
      NULL,
      NULL,
      0,
      2.273657,
      1,
      0.001921,
      0.657744,
      0,
      3.860960,
      0,
      3,
      3.734656,
      NULL,
      1,
      1.416702,
      0,
      3.895371,
      0,
      0,
      NULL,
      1.045294,
      NULL,
      NULL,
      0.463739,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0.333924,
      0,
      1,
      1.469680,
      0.199528,
      1.282957,
      NULL,
      1,
      1.277057,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.012367,
      0.747552,
      1,
      0,
      1.182332,
      NULL,
      1,
      1.839572,
      5,
      1,
      2,
      NULL,
      0,
      0,
      2,
      0,
      3.981064,
      5.354625,
      NULL,
      5,
      5,
      NULL,
      NULL,
      NULL,
      5.361645,
      NULL,
      0,
      0,
      0.003877,
      1.755749,
      0.867018,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616014,
      0.179036,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996505,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.484369,
      1,
      1.988745,
      NULL,
      3,
      0,
      2.277348,
      1.273962,
      0.545723,
      2.603943,
      4.579330,
      NULL,
      1,
      0,
      NULL,
      1,
      0.507165,
      NULL,
      NULL,
      NULL,
      1,
      1.396684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.113381,
      2.168130,
      2,
      NULL,
      3,
      1.129087,
      1,
      0.039625,
      0.888558,
      0.504123,
      NULL,
      0.768440,
      1.581296,
      0.058127,
      0.280078,
      1,
      1.521291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.533021,
      NULL,
      '03034',
      '',
      1.066473,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


