set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '21',
      39,
      17,
      '3432123',
      63,
      6,
      NULL,
      0,
      '001232',
      NULL,
      NULL,
      NULL,
      90.793853,
      1,
      NULL,
      2.360199,
      3.833014,
      1.505171,
      1.167288,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.177791,
      1.237961,
      1.590863,
      0,
      0.872909,
      NULL,
      1.663754,
      0,
      NULL,
      1.284881,
      3.291542,
      4.263467,
      1,
      2.507281,
      0.201960,
      NULL,
      0.409384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4.162432,
      0,
      1.366351,
      NULL,
      0,
      0.042046,
      NULL,
      0.031570,
      NULL,
      0,
      0,
      1.877924,
      NULL,
      1,
      0.128724,
      1,
      NULL,
      3.401697,
      0.937439,
      0,
      0.949998,
      6,
      1,
      0,
      1,
      0.437951,
      NULL,
      NULL,
      1.122154,
      NULL,
      NULL,
      0,
      1.107937,
      0,
      1.576098,
      1,
      NULL,
      0.333219,
      NULL,
      1.821858,
      0.223010,
      1,
      1.551575,
      1.702766,
      NULL,
      NULL,
      0,
      1.484928,
      1,
      1,
      NULL,
      0.514910,
      1,
      1.682168,
      NULL,
      0.632261,
      1,
      1.902107,
      1,
      1.025072,
      1.350904,
      NULL,
      1,
      0.569381,
      NULL,
      3.236051,
      1.879661,
      4.103337,
      7,
      1,
      7.911720,
      2.816326,
      2,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      1.136359,
      NULL,
      1.151717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045258,
      0,
      1,
      0,
      0.375329,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532232,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269842,
      1.480681,
      0.907327,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.763923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.199083,
      1.256206,
      1,
      1.716084,
      1,
      0.218541,
      3,
      0.176573,
      2,
      0.755792,
      0,
      1.825776,
      0.338625,
      NULL,
      1.598406,
      0,
      1.157930,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '00334',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.823141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


