set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '30',
      19.013155,
      1.008817,
      '1444220',
      4,
      1,
      2.356008,
      NULL,
      NULL,
      1,
      '11- 9-1984',
      18,
      116.284443,
      0,
      NULL,
      1.204710,
      1.992716,
      0,
      0.687347,
      1.705207,
      NULL,
      0,
      1.989816,
      0,
      NULL,
      1,
      0,
      NULL,
      0.835208,
      0,
      1.130470,
      0.704876,
      NULL,
      0.660813,
      NULL,
      1.289199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.174604,
      1,
      1.168159,
      2,
      2,
      NULL,
      2,
      1.427836,
      NULL,
      0,
      1.773802,
      NULL,
      0,
      2,
      0.790439,
      NULL,
      0,
      0.238811,
      0.243639,
      1.456638,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.247750,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.252761,
      1.805019,
      NULL,
      1,
      0,
      1.052804,
      0,
      NULL,
      0.362555,
      1,
      0,
      0,
      1.369207,
      NULL,
      NULL,
      0.612919,
      NULL,
      0.683463,
      0.040828,
      0,
      NULL,
      0,
      1.679534,
      1.874389,
      0.312588,
      NULL,
      0,
      3.557286,
      1,
      1,
      1.867418,
      1,
      0,
      0.613344,
      0,
      2.479410,
      NULL,
      1.378871,
      NULL,
      3,
      NULL,
      6.580554,
      NULL,
      1,
      0,
      0.181617,
      NULL,
      1.427673,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.487225,
      1,
      0,
      0,
      0.702271,
      0.222266,
      0.110721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170186,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.694320,
      0,
      1.274908,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.826059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.427858,
      1.286843,
      1,
      NULL,
      0,
      2,
      1.357799,
      NULL,
      1,
      0.364043,
      1.598877,
      1.435384,
      0,
      1,
      1,
      0,
      1,
      0.751780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.132644,
      '21101',
      '21141',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


