set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12',
      42.468538,
      5.011903,
      '0223224',
      84.799357,
      2,
      1.780281,
      2,
      '441040',
      3.167580,
      ' 8-15-1990',
      16.815496,
      3,
      0.879659,
      NULL,
      0.215657,
      1,
      0.578363,
      NULL,
      0,
      NULL,
      NULL,
      0.397171,
      0,
      0.732833,
      NULL,
      NULL,
      1.456890,
      1,
      NULL,
      1.490905,
      1.743421,
      1.955901,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.190982,
      0,
      0,
      1.567796,
      1,
      1.204457,
      3.013186,
      0.218267,
      2.657545,
      1,
      0.042614,
      1,
      1,
      0,
      0,
      3,
      2.748261,
      1,
      0.758654,
      1.306962,
      1.122227,
      5.334307,
      1,
      0,
      0.544335,
      0,
      NULL,
      NULL,
      1.851457,
      NULL,
      NULL,
      0.769878,
      0.072762,
      1.143133,
      0,
      NULL,
      1,
      0.127574,
      NULL,
      1,
      1,
      NULL,
      1.879099,
      1,
      1,
      1.571384,
      1,
      1.488760,
      0,
      0.196642,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.811041,
      NULL,
      0,
      1.814809,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      2.581059,
      2.058899,
      0.220517,
      2,
      5.230665,
      0,
      NULL,
      0,
      1.293117,
      NULL,
      0.624010,
      NULL,
      1.050393,
      9.388289,
      1.780153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.065114,
      0,
      NULL,
      0,
      1.817552,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060887,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.916880,
      0,
      1.811631,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.399752,
      0.068144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539041,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.393690,
      0.721909,
      1.810715,
      0,
      1,
      NULL,
      1,
      1.260858,
      1,
      1.172405,
      1.151304,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '20211',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.857417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


