set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      17.104050,
      '3020133',
      45.196107,
      4,
      2.692588,
      NULL,
      '031341',
      4.568769,
      '11-20-1992',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.156271,
      2,
      1.504250,
      1.462482,
      0.016052,
      0.291593,
      1.054829,
      NULL,
      0.466644,
      0,
      0.722263,
      0,
      1,
      0,
      1.214705,
      0,
      0,
      1.690700,
      0.871015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.317096,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      1.078027,
      2.540827,
      0,
      0,
      1,
      NULL,
      3,
      1,
      1.351079,
      0,
      NULL,
      1.675098,
      5,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.104177,
      0,
      0.331837,
      1,
      1,
      1,
      1,
      1,
      0,
      1.051597,
      NULL,
      0.748556,
      NULL,
      NULL,
      0.398113,
      0,
      1,
      1.462861,
      NULL,
      0.300283,
      0,
      1,
      1.077896,
      0.701777,
      1.488823,
      1.599492,
      0,
      0,
      0.460533,
      1.076261,
      1.888689,
      0,
      NULL,
      1,
      0.962073,
      4,
      4.199220,
      5,
      NULL,
      4.220786,
      4,
      3.590882,
      NULL,
      4,
      NULL,
      1,
      1.498503,
      0,
      1,
      1.560520,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885664,
      1,
      1,
      1,
      0.409692,
      0.206115,
      1,
      0.117362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.666402,
      1.741194,
      1.666473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651502,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.120803,
      0,
      0.495513,
      NULL,
      0,
      1,
      1,
      0.028540,
      0.175903,
      3.204860,
      NULL,
      0,
      NULL,
      0.822873,
      0,
      0.217498,
      1.335284,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '24303',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      1.953895,
      '',
      '',
      NULL,
      0.679149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


