set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '34',
      18,
      29,
      '3231201',
      20.860203,
      NULL,
      3.318587,
      2,
      NULL,
      NULL,
      NULL,
      31.360845,
      37.940005,
      0.522408,
      NULL,
      2.875664,
      0,
      1.018752,
      NULL,
      NULL,
      0.340327,
      3.345737,
      1,
      1,
      0.253203,
      0,
      1,
      NULL,
      0.187719,
      1,
      0.406991,
      1,
      1.954341,
      0,
      NULL,
      0.476061,
      0.930748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.514301,
      0.658071,
      1,
      0,
      1,
      NULL,
      NULL,
      1.270866,
      3.648211,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1.527653,
      3.672693,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1.107286,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.560358,
      1,
      1,
      1.898417,
      NULL,
      1,
      1,
      0.990622,
      0.963607,
      1,
      0.239219,
      NULL,
      0,
      1,
      1.149523,
      0,
      1.866092,
      NULL,
      0.022507,
      0,
      1,
      1,
      0.327116,
      1.127177,
      0.918466,
      1.047297,
      1,
      1.897137,
      1.286558,
      1,
      0,
      0.955551,
      0,
      NULL,
      3,
      0,
      NULL,
      2.077089,
      3,
      7,
      NULL,
      1.060254,
      0.954997,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0.151366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.366962,
      3.941558,
      0,
      0.672163,
      1,
      1.289880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574805,
      0,
      0.269215,
      1.799525,
      1.961127,
      NULL,
      0.499546,
      NULL,
      NULL,
      NULL,
      0.263044,
      NULL,
      1.380422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433191,
      1.756245,
      0.876636,
      1,
      1,
      1.759788,
      0,
      NULL,
      1.273009,
      0,
      0.451557,
      0,
      1,
      1,
      1,
      0,
      1.565837,
      NULL,
      1.099661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04224',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.637403,
      '',
      '',
      '',
      4.219809,
      1.413477,
      1.442062,
      NULL,
      0,
      1.071288,
      1.329061,
      0,
      3);
commit;
end;
/


