set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '10124032',
      40.960388,
      57,
      '2103140',
      NULL,
      6,
      0.025326,
      NULL,
      '120242',
      NULL,
      ' 8-21-1977',
      24.780162,
      58.860224,
      1,
      NULL,
      1.324936,
      3.840750,
      1,
      0.320940,
      NULL,
      1.988780,
      1,
      1.545528,
      0.557768,
      1,
      NULL,
      1.504123,
      1,
      0,
      1.332085,
      0,
      NULL,
      1.254638,
      NULL,
      1.571169,
      1,
      1,
      0.795970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.964558,
      4,
      0,
      NULL,
      1,
      1.507707,
      2,
      2.892434,
      0,
      2,
      NULL,
      1.739097,
      1.396595,
      1.309399,
      0.984120,
      1.926106,
      2,
      3,
      NULL,
      1.991491,
      0,
      0.585769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420829,
      1.071313,
      0.756120,
      NULL,
      0,
      1,
      0.084592,
      0,
      1.634361,
      NULL,
      1.518407,
      NULL,
      0,
      1.755184,
      1.384059,
      1,
      1,
      1,
      1.534613,
      NULL,
      0,
      1,
      0.320899,
      NULL,
      0.247177,
      1,
      1,
      1,
      0,
      0,
      0.944468,
      1.387690,
      0.292958,
      NULL,
      1,
      1,
      5,
      5.548774,
      1,
      2,
      3,
      2,
      0.121419,
      3.823378,
      0,
      0.724095,
      NULL,
      1.816650,
      NULL,
      0.041168,
      1,
      8.966036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.744259,
      1.363375,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014068,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652277,
      0.210027,
      0.034107,
      1,
      1.942971,
      0,
      0.715383,
      NULL,
      NULL,
      NULL,
      0.958230,
      0.390662,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153872,
      1.880109,
      NULL,
      3.318759,
      0.588183,
      1.730727,
      1,
      NULL,
      1,
      0,
      NULL,
      0.551204,
      0,
      NULL,
      1.696044,
      1,
      NULL,
      0.816869,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.867909,
      '30114',
      NULL,
      '',
      0.981583,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.798705,
      2.093765,
      3,
      0,
      2.716488,
      2.901705,
      2,
      3);
commit;
end;
/


