set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      NULL,
      35.242844,
      NULL,
      NULL,
      23,
      0,
      3,
      NULL,
      NULL,
      1,
      ' 8-17-1996',
      12.603685,
      23,
      1,
      NULL,
      0.991996,
      0,
      1,
      NULL,
      1,
      1,
      0.012853,
      0,
      1,
      NULL,
      0,
      0.572640,
      0.010531,
      0,
      0,
      1,
      NULL,
      1.343147,
      1.884201,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599382,
      3,
      0,
      3,
      0,
      1.554506,
      2.881321,
      1,
      NULL,
      0.166865,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      2,
      1,
      0.619271,
      NULL,
      1,
      0,
      1,
      NULL,
      0.402036,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.881434,
      1.085958,
      0,
      0.104221,
      1,
      0,
      1.181873,
      0.968007,
      0.458207,
      0,
      1,
      0,
      NULL,
      NULL,
      0.702299,
      1,
      1,
      0,
      0.698924,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0.778712,
      NULL,
      0.493652,
      0,
      0,
      1,
      NULL,
      6.436120,
      3.833401,
      1,
      0,
      NULL,
      5.841694,
      1,
      4.536144,
      2,
      0.833961,
      0.480070,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.921055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189455,
      0,
      1,
      NULL,
      1,
      0,
      0.110864,
      1.706270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.237126,
      0.544099,
      1.433252,
      NULL,
      NULL,
      NULL,
      0.009609,
      0.684128,
      0,
      1,
      0.142582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517983,
      0.888393,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.469999,
      NULL,
      0.253641,
      0.214049,
      1.580218,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.973109,
      1,
      0,
      NULL,
      0,
      NULL,
      1.163196,
      1.890669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.242214,
      '44041',
      '43112',
      '',
      0.983883,
      '',
      '',
      '',
      1.645596,
      '',
      '',
      '',
      NULL,
      1.872161,
      1.575072,
      3,
      2,
      3,
      1.756226,
      1.415906,
      1.539263);
commit;
end;
/


