set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      NULL,
      NULL,
      62.077949,
      '1433001',
      151.404811,
      NULL,
      3.853281,
      NULL,
      '133244',
      5,
      ' 6- 5-1982',
      8.161337,
      1.188098,
      1.686001,
      NULL,
      9.145319,
      2.375201,
      1,
      0.362567,
      0.943759,
      0.608406,
      0,
      1.805074,
      1.165672,
      1,
      1.282250,
      0.970578,
      0.240732,
      0.163963,
      NULL,
      NULL,
      1.700572,
      0,
      1,
      1.151738,
      1.103812,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      3.893597,
      1.221137,
      0.311496,
      1,
      NULL,
      3.893879,
      2.870384,
      0,
      0,
      1,
      NULL,
      1.767413,
      NULL,
      NULL,
      2,
      0,
      0.233495,
      0,
      1,
      0,
      0,
      1,
      1.387200,
      0.860299,
      NULL,
      NULL,
      1.440879,
      NULL,
      NULL,
      NULL,
      0.039138,
      1.246939,
      0.702863,
      0.159480,
      0.719271,
      NULL,
      NULL,
      0,
      0.641668,
      1.002935,
      0,
      1,
      0.143711,
      NULL,
      NULL,
      1.510233,
      1.520300,
      1.573109,
      NULL,
      1,
      NULL,
      0,
      0,
      1.580942,
      0,
      NULL,
      1.141388,
      0.975612,
      0,
      1.740320,
      NULL,
      0.020500,
      0.549098,
      0,
      1.610491,
      5,
      7,
      6.240563,
      0,
      4.656715,
      4,
      5,
      3.389041,
      4.123561,
      1,
      3,
      0,
      1.546066,
      NULL,
      NULL,
      7,
      0.506575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.120042,
      1,
      1,
      0,
      NULL,
      1,
      0.051331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846025,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.049200,
      NULL,
      NULL,
      0.931798,
      0.288037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871306,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094894,
      1,
      1.298278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.098569,
      1,
      NULL,
      1,
      1.194706,
      0,
      0.793861,
      NULL,
      3.847280,
      0,
      NULL,
      1,
      NULL,
      1,
      0.175877,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.088195,
      '34040',
      '13144',
      '',
      1.030299,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      5.800213,
      3.922038,
      0,
      3.730853,
      2,
      0.369935,
      1.939518,
      0.240251,
      1);
commit;
end;
/


