set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '11244223',
      43.152452,
      57.202800,
      '4213041',
      172.829168,
      4,
      1.971785,
      0,
      '040232',
      3,
      ' 4- 7-1978',
      16,
      24,
      0,
      NULL,
      8,
      0.201644,
      1,
      1,
      1,
      2,
      1,
      1.717195,
      0,
      NULL,
      NULL,
      1,
      0.782049,
      0.879549,
      1.885712,
      0,
      NULL,
      1.872416,
      NULL,
      0.384491,
      0.134441,
      1.576969,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.875198,
      0.825478,
      0,
      1,
      NULL,
      NULL,
      3,
      1.901364,
      1.282486,
      2.028438,
      0,
      0.433638,
      3,
      NULL,
      1.808354,
      0,
      3.602876,
      1.511590,
      0,
      1.637264,
      NULL,
      4,
      1,
      2,
      3,
      1.056217,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0.130823,
      0.083274,
      0,
      0,
      1,
      1,
      1.741603,
      0,
      0,
      0,
      1,
      0.989423,
      NULL,
      1.403409,
      0.781372,
      1,
      NULL,
      1.585737,
      1,
      0,
      0.833268,
      1,
      0.422048,
      0.975974,
      1.473220,
      1,
      0.375129,
      0,
      0,
      1,
      NULL,
      0.347352,
      1,
      0,
      1.427064,
      5.165149,
      NULL,
      7.015402,
      NULL,
      7.343465,
      3,
      NULL,
      0,
      0,
      4,
      0.688075,
      NULL,
      NULL,
      1.656643,
      0.868100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.911744,
      1,
      NULL,
      0.398989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.832144,
      3.824125,
      1,
      0.847983,
      NULL,
      1.176401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.539412,
      NULL,
      0.232107,
      NULL,
      NULL,
      NULL,
      0.209062,
      0.474044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026647,
      1.875138,
      0,
      2.103417,
      1,
      0.731097,
      1.090155,
      0.917645,
      NULL,
      2.199241,
      3.276727,
      0,
      NULL,
      NULL,
      1,
      0,
      1.546592,
      1,
      1,
      0.072295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '21202',
      '20411',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.003548,
      0,
      2,
      NULL,
      0,
      NULL,
      1.802089,
      1.231662);
commit;
end;
/


