set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3102',
      '14310324',
      22,
      63.180688,
      '3423413',
      200,
      NULL,
      2.129166,
      3,
      '132432',
      2,
      ' 5- 7-1975',
      4.721826,
      18,
      0.886288,
      NULL,
      NULL,
      1.805516,
      1,
      1.763778,
      1,
      NULL,
      0,
      0.010507,
      1.416670,
      1.918126,
      NULL,
      0,
      1,
      0.744507,
      0.177043,
      1,
      1,
      NULL,
      1.699591,
      1.847940,
      0.579632,
      1,
      1.359888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409831,
      0.337768,
      1,
      1,
      NULL,
      0,
      1.815202,
      1.128313,
      0.436260,
      NULL,
      1,
      1,
      1,
      3.113124,
      NULL,
      1,
      3.128700,
      1,
      1.078822,
      1,
      0,
      1,
      5,
      0,
      0,
      3,
      0.674268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448878,
      4,
      0,
      1,
      3.556387,
      1,
      0,
      0.330512,
      0,
      NULL,
      NULL,
      NULL,
      1.291835,
      1.951109,
      0,
      0,
      0.097668,
      1,
      0.472647,
      NULL,
      0.672051,
      1,
      NULL,
      0,
      0.889892,
      0.191678,
      1.768638,
      1.795582,
      1,
      1.643375,
      1.073121,
      0.026565,
      1.762803,
      NULL,
      1.018101,
      NULL,
      2,
      7,
      2.418517,
      7.166564,
      2.134829,
      4.593440,
      0,
      NULL,
      3,
      3,
      0.325344,
      1.445516,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097199,
      1.803608,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531669,
      2.623260,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.220212,
      NULL,
      3.237956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.975902,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843636,
      1.690379,
      1,
      3.583991,
      NULL,
      NULL,
      NULL,
      0.191362,
      1.403633,
      0.086669,
      2,
      NULL,
      0.281816,
      0.431297,
      0,
      1,
      0.572530,
      0.498891,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      '42203',
      '30212',
      NULL,
      0.415098,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      3.121933,
      0,
      1,
      1.957871,
      1.480686,
      3,
      3.332361,
      3.139616);
commit;
end;
/


