set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21311212',
      0.737372,
      27.118670,
      NULL,
      67.514989,
      3,
      2.965867,
      1,
      '402340',
      5.894078,
      ' 0-20-1997',
      NULL,
      41,
      1,
      NULL,
      1.620273,
      1,
      NULL,
      0,
      1.843275,
      2,
      0.217921,
      0.749464,
      NULL,
      0,
      0.254994,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1.934821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129404,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      2.269241,
      2.534090,
      3,
      NULL,
      0,
      0.263823,
      1,
      3,
      0,
      1,
      1.709631,
      1.064097,
      1.479042,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226929,
      NULL,
      NULL,
      1.314782,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.120040,
      0,
      0.146536,
      1,
      0,
      1.223441,
      1,
      0,
      0,
      0.855402,
      0,
      0,
      1.569672,
      NULL,
      0,
      1.062337,
      NULL,
      0.052952,
      NULL,
      0.610841,
      1,
      0.624933,
      1,
      0,
      1.378623,
      1,
      1.018559,
      NULL,
      0.498390,
      NULL,
      4.120574,
      0.709803,
      7.346078,
      NULL,
      4.059021,
      7,
      NULL,
      3.404839,
      1.036120,
      1,
      1.045252,
      1.494359,
      1,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1.066082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514655,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.477386,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      0.350576,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.045660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524329,
      0.420387,
      0,
      NULL,
      0,
      0,
      NULL,
      0.115568,
      1,
      3.985752,
      NULL,
      0.837268,
      0,
      1,
      1.521802,
      1.254522,
      0.406366,
      NULL,
      0.269579,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '33413',
      '',
      '',
      0.625954,
      '',
      NULL,
      '',
      0,
      '3242',
      NULL,
      '',
      2,
      NULL,
      1,
      2.409155,
      NULL,
      0.566858,
      3.465176,
      0,
      2.781420);
commit;
end;
/


