set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3001',
      NULL,
      52,
      16.370956,
      '3012033',
      41.860040,
      0,
      3,
      1,
      '301140',
      5,
      '10- 1-1977',
      35,
      29,
      NULL,
      NULL,
      1.399265,
      0,
      NULL,
      1.343765,
      1,
      NULL,
      0.247496,
      NULL,
      NULL,
      0.687693,
      1.106387,
      0.735861,
      0.155272,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0.612069,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.670258,
      1.762051,
      3,
      0.438913,
      1.245174,
      0,
      3.614161,
      1.910168,
      NULL,
      0.938730,
      0.903981,
      1,
      0.436429,
      0,
      1.517264,
      2.167863,
      0,
      0.732391,
      NULL,
      0.145987,
      0,
      4,
      0,
      NULL,
      2.787883,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.911140,
      1,
      NULL,
      0,
      NULL,
      1.588886,
      0.951403,
      0.672849,
      0.329656,
      0.083176,
      1,
      1.829943,
      0,
      0.031420,
      1.937464,
      NULL,
      0.997858,
      1,
      0.662344,
      NULL,
      1.187957,
      1.129089,
      NULL,
      1.404407,
      NULL,
      0.672398,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.713017,
      1,
      0,
      2,
      6.766218,
      2.108647,
      0.318228,
      NULL,
      7,
      3,
      NULL,
      5.697324,
      3,
      0.174210,
      0.749430,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.935427,
      1,
      NULL,
      0.237443,
      1,
      1.119045,
      1.912785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.606569,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236257,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937407,
      0,
      0.080928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.452166,
      1,
      0.783932,
      1,
      1,
      1.487095,
      NULL,
      2,
      3.684240,
      0.775166,
      1,
      1.759376,
      1.306005,
      0,
      0.064685,
      1.932088,
      NULL,
      0.444910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '10322',
      NULL,
      '',
      1.762089,
      '',
      '',
      '',
      3.880422,
      '2021',
      NULL,
      '',
      5.623884,
      NULL,
      3.801422,
      1.523767,
      0,
      1,
      2.829147,
      2,
      1);
commit;
end;
/


