set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '44100431',
      21,
      66,
      NULL,
      8,
      NULL,
      1,
      0,
      NULL,
      3,
      ' 4-12-1999',
      25.306190,
      46.182551,
      NULL,
      NULL,
      3.659255,
      0.774249,
      1,
      0,
      1,
      3,
      NULL,
      0,
      0,
      0.307113,
      3.232524,
      NULL,
      1,
      1.463741,
      NULL,
      0.353409,
      2.411215,
      NULL,
      1.017983,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.240877,
      NULL,
      NULL,
      NULL,
      0.484084,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630296,
      1.283843,
      NULL,
      0.449382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.216119,
      3,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0.598311,
      0,
      0,
      1.448880,
      0,
      NULL,
      NULL,
      1.144356,
      NULL,
      1.030156,
      0.075260,
      0,
      1.126030,
      1.275627,
      0,
      3.589448,
      0,
      5,
      NULL,
      2.290884,
      5.319274,
      NULL,
      1,
      NULL,
      NULL,
      1.173865,
      NULL,
      1,
      7,
      7,
      NULL,
      3,
      2.514024,
      3.960397,
      0,
      3,
      NULL,
      0.290699,
      NULL,
      NULL,
      0.802747,
      0.920933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0.386148,
      1.234913,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.699482,
      NULL,
      8.191047,
      0.993215,
      0.524741,
      0.652034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.678849,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5.620943,
      1.566959,
      4.157820,
      1,
      2.821517,
      0,
      NULL,
      NULL,
      1,
      1.340498,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.471123,
      1.251539,
      0,
      1.283199,
      NULL,
      0,
      2,
      0.175039,
      1,
      NULL,
      NULL,
      0.932458,
      NULL,
      NULL,
      0.249266,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24240',
      NULL,
      '',
      1.777575,
      '11303',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.374185,
      0.851153,
      2,
      2,
      1,
      0,
      0,
      3.222295,
      2.840971);
commit;
end;
/


