set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0031',
      NULL,
      11.811280,
      74.328505,
      NULL,
      12,
      2,
      0.478683,
      2,
      '310241',
      5.140338,
      ' 5-28-1977',
      20.120585,
      NULL,
      0,
      NULL,
      1.652291,
      0.151997,
      2.971731,
      NULL,
      0.813120,
      0,
      0.205086,
      NULL,
      1,
      NULL,
      3.433697,
      NULL,
      0.553178,
      1,
      1.351748,
      NULL,
      4.698310,
      0.145434,
      0,
      1.101664,
      1,
      0,
      NULL,
      NULL,
      3,
      0.165890,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.413256,
      1.138025,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.789389,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.610671,
      5.635173,
      1.533839,
      NULL,
      NULL,
      1.971189,
      NULL,
      1.501150,
      0.099139,
      NULL,
      0,
      1,
      0.760750,
      1.689189,
      1,
      1,
      NULL,
      1,
      5,
      NULL,
      0.593985,
      NULL,
      0,
      NULL,
      1,
      3.211426,
      0.472746,
      0.192714,
      5.399472,
      5,
      1,
      0.178952,
      NULL,
      3.770981,
      NULL,
      NULL,
      0,
      8,
      9,
      NULL,
      3.317945,
      NULL,
      1,
      2,
      0.529928,
      1,
      NULL,
      NULL,
      0.228017,
      1.080546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.728831,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.569509,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.428494,
      0,
      0.742307,
      3.743748,
      0.828941,
      0,
      2.430423,
      1,
      8,
      4.344576,
      NULL,
      1,
      2.669047,
      1.248181,
      NULL,
      NULL,
      0,
      3.170585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.961701,
      NULL,
      0,
      1.416683,
      0.128022,
      0.358241,
      2,
      0.825594,
      0.392229,
      NULL,
      0.996820,
      NULL,
      1,
      NULL,
      1.471699,
      1.491778,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '41442',
      '',
      '',
      1.376187,
      '30143',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3,
      2.878654,
      NULL);
commit;
end;
/


