set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2230',
      '31131101',
      79,
      51.539150,
      '3211141',
      41,
      6,
      1.996936,
      2,
      '023330',
      2,
      NULL,
      41.287089,
      32.217363,
      1.474284,
      NULL,
      2,
      NULL,
      1,
      1.033329,
      1,
      NULL,
      0.782430,
      1.948307,
      0,
      0.860431,
      NULL,
      1,
      1.065275,
      1.418645,
      NULL,
      NULL,
      2,
      0.498881,
      0,
      NULL,
      NULL,
      1,
      4,
      0,
      3,
      1.711090,
      0,
      0,
      NULL,
      NULL,
      0.472905,
      NULL,
      NULL,
      0.266499,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424196,
      0,
      4.955070,
      0,
      0.768983,
      0.914469,
      0.748689,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1.241460,
      0,
      1.819505,
      1.890888,
      NULL,
      NULL,
      0,
      2.882418,
      1,
      1.226671,
      NULL,
      NULL,
      1.533103,
      0.043429,
      4.333735,
      1.519317,
      NULL,
      NULL,
      3,
      1,
      1.831460,
      1,
      6.259329,
      0.129616,
      7,
      NULL,
      9,
      2,
      3,
      NULL,
      5.935654,
      1.896337,
      0.648534,
      0.069794,
      NULL,
      NULL,
      NULL,
      0.841351,
      0.663996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641486,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1.210528,
      0.608974,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.534272,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.077441,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.014583,
      0,
      0.174049,
      2.169300,
      NULL,
      2,
      3.942288,
      NULL,
      3.785317,
      1.510571,
      0,
      NULL,
      0,
      1,
      1,
      1.990295,
      1,
      0,
      0.850311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.183375,
      '00444',
      '',
      '',
      1.709070,
      '33003',
      '',
      NULL,
      0.881870,
      '',
      '',
      '',
      2,
      5,
      0.864740,
      3.828057,
      NULL,
      4,
      0.619383,
      NULL,
      0.990356);
commit;
end;
/


