set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1413',
      '43244110',
      5,
      58.095455,
      '3302233',
      42.588066,
      4,
      1,
      3,
      '224212',
      NULL,
      ' 0-10-1995',
      5.916736,
      58,
      0.571017,
      NULL,
      1.844621,
      NULL,
      0,
      NULL,
      0.026025,
      2,
      0.622016,
      NULL,
      NULL,
      1,
      3.494496,
      0,
      0,
      3,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      8,
      0,
      3.764035,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.970795,
      1.731880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.613531,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328625,
      5.201877,
      3,
      0.063310,
      NULL,
      1,
      0.324819,
      0.968229,
      NULL,
      0,
      NULL,
      0.511629,
      0.613582,
      0,
      1,
      1,
      0.577714,
      0,
      0.169310,
      NULL,
      0.822721,
      1.269976,
      1.245189,
      NULL,
      1.270700,
      0.133320,
      0.187508,
      0,
      0,
      2,
      0.007373,
      2,
      0,
      0.058085,
      NULL,
      1.371117,
      1.020018,
      2.836927,
      0.040743,
      7,
      NULL,
      0.878321,
      5,
      6.725831,
      3.960077,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      6,
      1.489157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268055,
      2,
      0,
      1,
      1.097115,
      1.508060,
      1.022867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.978551,
      NULL,
      0,
      NULL,
      3.689050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.070546,
      NULL,
      3,
      0.742947,
      NULL,
      4,
      1.203254,
      6,
      1.274586,
      0.565460,
      1,
      4.710145,
      1.843280,
      NULL,
      NULL,
      1.629425,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.324321,
      0,
      2,
      0.050575,
      NULL,
      2,
      0.570942,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.650371,
      0,
      0.428575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.973014,
      '13342',
      '',
      '',
      NULL,
      '23113',
      '',
      '',
      1.866402,
      '',
      '',
      '',
      5.863314,
      NULL,
      2.409775,
      4,
      0.365482,
      0,
      0.325373,
      2,
      0.178681);
commit;
end;
/


