set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '42',
      42,
      15,
      '3443342',
      74,
      2,
      3.598269,
      1,
      '124012',
      5,
      ' 8- 0-1981',
      37.653314,
      36,
      NULL,
      NULL,
      8,
      1,
      1.652325,
      NULL,
      1.791343,
      0.990745,
      NULL,
      0.871875,
      0,
      0.942162,
      1,
      NULL,
      0.518823,
      0.904373,
      NULL,
      1.124208,
      1.435600,
      1.982398,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982096,
      0,
      0,
      1.698074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.202053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.468624,
      0,
      4.434765,
      1.526101,
      1.888596,
      0.579484,
      4.944982,
      3.786668,
      NULL,
      0.647285,
      NULL,
      1.796970,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.284063,
      0.143855,
      1.601465,
      1.925408,
      1.732073,
      0.194832,
      NULL,
      1.882284,
      NULL,
      0,
      0.009833,
      0.620370,
      1,
      1.635146,
      1.139523,
      NULL,
      1,
      1,
      NULL,
      4.140592,
      1,
      3,
      1.733110,
      1,
      NULL,
      NULL,
      6,
      0.178485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.298341,
      1,
      1,
      1.718579,
      0,
      0.654071,
      0.465235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.081995,
      2.493445,
      1.289822,
      NULL,
      NULL,
      3,
      1,
      0.167955,
      0.543741,
      NULL,
      NULL,
      NULL,
      1.668223,
      0,
      NULL,
      NULL,
      1.356469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721863,
      1.331267,
      1.479894,
      1,
      0.850407,
      NULL,
      1,
      0,
      0.597656,
      1.715515,
      1.689541,
      1,
      0.380960,
      1.849550,
      1,
      1,
      1.527880,
      1.936773,
      1.054008,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.919580,
      '04443',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.257829,
      '',
      NULL,
      '',
      3.234839,
      3.110524,
      1,
      1.064485,
      1,
      0.270158,
      0,
      1.722165,
      3);
commit;
end;
/


