set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '34344031',
      29,
      34.845846,
      '4012211',
      132.778975,
      6,
      1,
      3,
      NULL,
      5.152166,
      NULL,
      36,
      14.776232,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0.366329,
      2,
      0.155091,
      0,
      NULL,
      1.534382,
      1,
      NULL,
      0,
      1.611800,
      1,
      0,
      NULL,
      NULL,
      0.722037,
      0.155758,
      NULL,
      2.230724,
      0,
      0,
      2,
      2.553733,
      1.441860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.182625,
      1.419228,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526939,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876226,
      NULL,
      1,
      1.807685,
      0.385382,
      4.231992,
      4,
      0,
      1.537218,
      1,
      NULL,
      2.071789,
      1.875926,
      0,
      1,
      0,
      1,
      0.925562,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0.214543,
      1.518747,
      1.155605,
      0,
      0,
      0.747885,
      1,
      NULL,
      0.964191,
      0,
      NULL,
      0,
      1.247235,
      0.223728,
      0.621635,
      1,
      NULL,
      NULL,
      0,
      4.506841,
      NULL,
      NULL,
      3.522711,
      0,
      NULL,
      NULL,
      NULL,
      0.044963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.909281,
      1,
      0,
      1,
      NULL,
      1.808608,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030962,
      NULL,
      NULL,
      NULL,
      NULL,
      2.380987,
      NULL,
      3,
      1,
      1.734720,
      0.442402,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.390621,
      0.198985,
      NULL,
      0.840467,
      NULL,
      NULL,
      NULL,
      1,
      1.926199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547435,
      NULL,
      1.924030,
      1.815589,
      1.221012,
      1,
      0.271606,
      0,
      0.078203,
      2,
      0.452450,
      1,
      1,
      1,
      1.767066,
      1,
      0,
      1,
      0,
      0.180536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.831510,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      0,
      2.205014,
      0,
      2,
      0.300444,
      0,
      1,
      1.809087);
commit;
end;
/


