set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '44031120',
      33,
      28,
      '0120413',
      198.503654,
      NULL,
      3.829200,
      2,
      '234211',
      3.476363,
      ' 1-24-1985',
      14,
      17,
      0,
      NULL,
      1.325505,
      1,
      1.779308,
      0.522624,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      0.458606,
      1.871508,
      1.553100,
      1,
      1.469548,
      0.387582,
      0,
      1,
      1.505624,
      NULL,
      0,
      0.076746,
      1.377611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800837,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081066,
      1.056542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.660117,
      0,
      5,
      0.756471,
      NULL,
      0,
      6,
      2,
      4,
      NULL,
      0,
      1,
      1.656486,
      1,
      1.160577,
      NULL,
      NULL,
      1,
      0.530156,
      0,
      NULL,
      NULL,
      0,
      1,
      0.037732,
      1,
      1.196415,
      1,
      0.806616,
      1.415632,
      0.192221,
      0.919541,
      1,
      0.376277,
      3.933879,
      NULL,
      NULL,
      6.954480,
      1,
      5.602692,
      7.763966,
      1,
      0.551867,
      0.142644,
      0,
      0,
      NULL,
      NULL,
      1.444255,
      0.559947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136340,
      5,
      0,
      NULL,
      1.403592,
      0.298615,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.979810,
      0,
      0,
      3.044339,
      NULL,
      0.876151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426565,
      0,
      0.578702,
      1.447696,
      NULL,
      0,
      0.611542,
      NULL,
      NULL,
      NULL,
      0.412629,
      1.670398,
      0.531416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.078810,
      1.873165,
      1,
      2,
      1,
      NULL,
      1,
      0.340689,
      0,
      0.337997,
      NULL,
      0.595620,
      1.751204,
      1.600784,
      0.896218,
      NULL,
      1.134392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '13434',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.838691,
      NULL,
      NULL,
      '',
      NULL,
      0.305873,
      NULL,
      3.497276,
      2.153292,
      5,
      0,
      2,
      3);
commit;
end;
/


