set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '33424440',
      NULL,
      60,
      '0212411',
      48.785694,
      4,
      2,
      NULL,
      NULL,
      4.654182,
      '10-10-1980',
      3,
      125.998439,
      1.946408,
      NULL,
      1,
      3.884918,
      0,
      1,
      0.175265,
      0,
      3.100473,
      NULL,
      1.531336,
      1,
      2.203524,
      0,
      2.258243,
      0,
      1.361974,
      1.226188,
      NULL,
      0.668683,
      NULL,
      NULL,
      NULL,
      0.733940,
      5,
      1,
      0.334582,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.337716,
      NULL,
      NULL,
      0.789631,
      0.276354,
      0.411023,
      0.452801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492604,
      0,
      0,
      1.982296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410407,
      1.492313,
      0.027230,
      NULL,
      0,
      3,
      1.301821,
      NULL,
      0,
      0.354453,
      1,
      4,
      1,
      3.543794,
      0.730070,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.090650,
      1.790940,
      NULL,
      0.367080,
      0.062129,
      1,
      1,
      NULL,
      1,
      0.555677,
      0.038044,
      NULL,
      0.554855,
      0.662824,
      3,
      0,
      4.334052,
      NULL,
      1,
      0.945550,
      5,
      3,
      0.182109,
      0,
      3,
      1,
      NULL,
      NULL,
      7,
      1.890730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.188778,
      0,
      1,
      0.104782,
      1,
      0,
      1.365599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.119363,
      3.339944,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.040914,
      3.884454,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.416826,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.921351,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1.481566,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.963732,
      1,
      1.242672,
      0,
      1.017906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.199118,
      '32002',
      '',
      NULL,
      1.416212,
      NULL,
      '',
      '',
      1.023993,
      '',
      NULL,
      '',
      1.966437,
      0.951901,
      2,
      2.809163,
      2,
      4.933152,
      2.089782,
      1,
      2.898155);
commit;
end;
/


