set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43020121',
      51,
      49.420493,
      '0110121',
      18.609848,
      4,
      3,
      0,
      '344003',
      0,
      '11- 2-1979',
      42,
      48,
      1.873784,
      NULL,
      6.614118,
      0.492063,
      NULL,
      1,
      NULL,
      1.123741,
      1.496285,
      1.786123,
      NULL,
      0,
      0.234273,
      1.282528,
      1,
      0.387990,
      1,
      0,
      0,
      1.316867,
      0.889378,
      0,
      1,
      0.568647,
      1.867707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832068,
      1,
      1.148211,
      1.911498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.172817,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550180,
      NULL,
      0.094635,
      1,
      1,
      0.315321,
      1.226479,
      0,
      1.016204,
      0,
      1.460881,
      0,
      0.430639,
      1,
      0.064143,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.922355,
      0.005670,
      1,
      0.614152,
      1,
      1,
      0,
      1,
      1.442656,
      0,
      1,
      0,
      1.643230,
      1,
      1,
      0.250299,
      1.515180,
      3,
      4.381618,
      1.021809,
      3,
      5,
      0,
      2.578848,
      3,
      0,
      NULL,
      NULL,
      5.876473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.721616,
      1,
      1,
      1.086289,
      1.579992,
      1.584606,
      0.915735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882715,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.678881,
      0.625794,
      NULL,
      NULL,
      NULL,
      0.331357,
      NULL,
      2.348542,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736996,
      0.271223,
      0.334165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014217,
      1.970853,
      1.035864,
      1,
      2.483068,
      1.441105,
      0.177875,
      0,
      NULL,
      0,
      0,
      1,
      1.809902,
      0.915725,
      NULL,
      NULL,
      0,
      1.140683,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '10341',
      NULL,
      '',
      1.999511,
      '',
      '',
      '',
      1.711786,
      '',
      '',
      '',
      1,
      2.924039,
      3,
      3.780415,
      3.466393,
      1.693986,
      NULL,
      NULL,
      1);
commit;
end;
/


