set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4302',
      '03404334',
      NULL,
      5,
      NULL,
      36,
      2,
      0,
      3,
      '401333',
      5,
      ' 5-27-1993',
      51.452253,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.750602,
      NULL,
      1.325675,
      1,
      0.136243,
      NULL,
      0.223010,
      NULL,
      1,
      0.755818,
      0,
      0.579482,
      NULL,
      1,
      NULL,
      0.030341,
      0.022228,
      0.084778,
      0.048213,
      1.113873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.161564,
      1,
      1.529641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.130803,
      0.918152,
      0.853084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.487407,
      0,
      0,
      0,
      0.406797,
      1,
      0,
      1.554158,
      NULL,
      1,
      0,
      0,
      1,
      1.327930,
      0.784946,
      1.405943,
      0,
      1,
      NULL,
      1.087295,
      0.662671,
      1,
      0,
      1,
      NULL,
      0.829788,
      0.154074,
      0,
      0.989233,
      NULL,
      1.527093,
      1,
      NULL,
      NULL,
      0,
      1.752219,
      6,
      NULL,
      1,
      5,
      3.272625,
      5,
      2.773140,
      4.424607,
      NULL,
      6,
      4.324414,
      0.512836,
      NULL,
      NULL,
      NULL,
      1.724744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.789466,
      0.291180,
      0.619378,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188304,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.543726,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.678896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.678700,
      0,
      1.846296,
      0.744716,
      1,
      0.456004,
      NULL,
      1,
      1.889131,
      NULL,
      0,
      NULL,
      0,
      0.188063,
      1,
      0.382320,
      1.383370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34014',
      '',
      '',
      0.184931,
      '',
      NULL,
      NULL,
      NULL,
      '2041',
      '3003',
      '',
      0,
      2,
      0.994186,
      0,
      2.414430,
      0,
      2,
      2.781647,
      NULL);
commit;
end;
/


