set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '3033024',
      16,
      NULL,
      1.788087,
      2,
      '343341',
      1,
      ' 2- 5-1989',
      24,
      NULL,
      NULL,
      NULL,
      0,
      0.981147,
      1.295188,
      0,
      0.128814,
      1,
      1,
      NULL,
      1.230298,
      0.066968,
      0.150005,
      0,
      0,
      1,
      3.609252,
      0.824578,
      NULL,
      1,
      0,
      1.072039,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.666807,
      NULL,
      0,
      3.717260,
      0,
      3.947472,
      0.606531,
      1.967098,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.245403,
      4.135403,
      NULL,
      0,
      0.045910,
      0,
      NULL,
      NULL,
      0.102421,
      NULL,
      NULL,
      0,
      0.346173,
      0.032333,
      0,
      NULL,
      0.707699,
      0.709341,
      0,
      0,
      1.220206,
      0.753621,
      NULL,
      0,
      1,
      1.613605,
      1.774817,
      0.894833,
      NULL,
      1.355849,
      NULL,
      1.040626,
      4.858951,
      1,
      1.911667,
      1.688709,
      1.004944,
      1.535079,
      0.575079,
      NULL,
      5.034341,
      3.739623,
      3,
      5.844068,
      3,
      0,
      1.462159,
      1.524022,
      NULL,
      5.106583,
      2.000799,
      4.926255,
      5.309437,
      3,
      NULL,
      0.777182,
      1.653145,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1.333935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863737,
      1,
      0,
      1.374705,
      1.287630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.653292,
      2,
      0.714273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.377197,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063985,
      0,
      4.214251,
      NULL,
      0.671338,
      NULL,
      4.586471,
      0,
      NULL,
      NULL,
      NULL,
      0.586593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417385,
      1,
      NULL,
      1,
      1.932538,
      0,
      0,
      1.551140,
      1,
      1.612291,
      1,
      0.451138,
      0.573882,
      NULL,
      0.623574,
      1.370792,
      1,
      0,
      1.662335,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.623832,
      '00420',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


