set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2300040',
      NULL,
      NULL,
      3,
      3,
      '233230',
      2.444170,
      NULL,
      22,
      NULL,
      0,
      NULL,
      3.409685,
      1.897803,
      0,
      NULL,
      0,
      0.674301,
      NULL,
      NULL,
      3.283117,
      1,
      1,
      0.500775,
      NULL,
      1.779663,
      2.249270,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.167442,
      3,
      1,
      4.793982,
      NULL,
      0.059380,
      NULL,
      NULL,
      NULL,
      1.397385,
      NULL,
      NULL,
      3.266271,
      3.032675,
      2,
      0.562565,
      NULL,
      1.992298,
      1.570052,
      NULL,
      1.970273,
      0.030938,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.154202,
      1.773403,
      1,
      1.171826,
      6.884165,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0.519025,
      NULL,
      NULL,
      0.782386,
      5.330092,
      1.640792,
      1.816941,
      2,
      1,
      0,
      1.120237,
      2.626747,
      1.975214,
      0.814828,
      2.874203,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.928998,
      3,
      0,
      0.335908,
      NULL,
      1.570533,
      4.946687,
      NULL,
      0.144152,
      0.995076,
      2.128711,
      1,
      NULL,
      1.701335,
      0.482619,
      0.538381,
      1,
      NULL,
      1,
      1.315866,
      5,
      0.283073,
      2,
      NULL,
      5,
      6,
      14,
      2,
      3,
      0.666014,
      0,
      4,
      1.775549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203671,
      1.899630,
      1,
      0,
      NULL,
      1.772810,
      0,
      0.407087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667332,
      NULL,
      1,
      3.896100,
      0.408971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.703473,
      5.150472,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.415117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428053,
      13.711882,
      1,
      0,
      0,
      0.850560,
      0.264208,
      0.416926,
      1.360421,
      2.487133,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.018034,
      0.335350,
      1.191144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '33113',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


