set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '23',
      NULL,
      1,
      NULL,
      144,
      6,
      NULL,
      0,
      '042003',
      4,
      ' 1-18-1990',
      3.205408,
      4,
      0.564799,
      NULL,
      NULL,
      0.575316,
      3.759276,
      1,
      1,
      1.092157,
      NULL,
      NULL,
      NULL,
      0,
      1.106490,
      1.943216,
      0,
      3,
      NULL,
      0.860504,
      1,
      0.873966,
      0.985471,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      0.510627,
      0.627583,
      NULL,
      1.282224,
      0,
      1.993954,
      3.173433,
      0,
      1.770118,
      1.332180,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.168381,
      2,
      0.187146,
      1.189092,
      NULL,
      0.826153,
      4,
      0,
      2,
      0,
      1.819119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875302,
      0.418036,
      5,
      2,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1.127937,
      0,
      0.104000,
      0,
      5.567123,
      0.003851,
      NULL,
      1,
      1,
      1,
      NULL,
      0.504418,
      NULL,
      NULL,
      1.952410,
      0.310543,
      1,
      5,
      0.219048,
      NULL,
      1.983699,
      0.830379,
      0.262587,
      4.533611,
      0.338815,
      0,
      0,
      1,
      5,
      1.148123,
      3.161329,
      3,
      1,
      NULL,
      5,
      2.530340,
      3.986064,
      1.607053,
      3,
      0,
      NULL,
      NULL,
      7,
      0.212962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061768,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.085492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844290,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149146,
      1,
      3.081613,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335305,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1.964463,
      0.146568,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      2.192897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


