set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '23',
      14.503290,
      20,
      '3412324',
      9.392852,
      3,
      1,
      NULL,
      NULL,
      1,
      ' 2-15-1976',
      NULL,
      17,
      0.028912,
      NULL,
      NULL,
      1.194962,
      0.376755,
      0.508894,
      1.082367,
      NULL,
      0.426371,
      1,
      1.961080,
      0,
      1,
      NULL,
      2.435465,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.921312,
      0.750389,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.052056,
      NULL,
      NULL,
      2,
      0.398714,
      1,
      3.485781,
      0.082665,
      1,
      NULL,
      NULL,
      1,
      3.622194,
      1,
      1.105211,
      0,
      1,
      NULL,
      1,
      3,
      3.660116,
      1.984213,
      1,
      0.937015,
      0,
      3,
      1,
      0,
      1.719005,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.219597,
      NULL,
      0,
      5.272021,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.975432,
      NULL,
      1.113360,
      0,
      1,
      NULL,
      0,
      2.033606,
      0,
      1.484286,
      1,
      NULL,
      7.859238,
      0.787632,
      1,
      0.123760,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.682754,
      2.363063,
      1,
      3.428023,
      1,
      0.005699,
      1,
      6,
      7,
      0,
      NULL,
      5.159003,
      0,
      NULL,
      NULL,
      2.217199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237633,
      NULL,
      NULL,
      0,
      1.004905,
      0.867952,
      0.748548,
      0.814465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      0.024431,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.343366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.296906,
      3.842588,
      1.984639,
      0.268637,
      NULL,
      1,
      2.112126,
      0.145833,
      1.347123,
      0,
      0.303717,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


