set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41',
      NULL,
      NULL,
      '4121123',
      50,
      5,
      NULL,
      NULL,
      '041303',
      4.019211,
      ' 8-15-1987',
      41,
      99,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.447124,
      NULL,
      0.047929,
      0,
      0.248511,
      0.567638,
      NULL,
      0,
      0.263917,
      5,
      2,
      0.437332,
      0.591915,
      0.090996,
      0,
      NULL,
      0.920672,
      1,
      NULL,
      2.126240,
      1,
      2,
      1.143281,
      1.807194,
      1.574227,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1.784711,
      0.746099,
      1,
      1,
      1.208345,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      0,
      0.480131,
      NULL,
      4.724566,
      NULL,
      NULL,
      3,
      0.171474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.642059,
      NULL,
      1.567930,
      NULL,
      4.153335,
      0,
      0,
      NULL,
      NULL,
      0.406319,
      0,
      3.298471,
      1,
      1,
      0,
      NULL,
      1.063956,
      NULL,
      1,
      3.039222,
      4,
      1,
      NULL,
      2,
      0.390248,
      0,
      NULL,
      0.200080,
      0,
      3.348560,
      5,
      1,
      5.831252,
      0.340128,
      NULL,
      2,
      3,
      1,
      NULL,
      0,
      NULL,
      7.041410,
      NULL,
      0,
      3,
      1,
      0.087359,
      NULL,
      NULL,
      7.991245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.037795,
      1.284695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412010,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      3,
      0.704998,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.234733,
      2.398933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.783292,
      0.787329,
      0,
      2,
      2.585606,
      NULL,
      2,
      1,
      0,
      1,
      0.785511,
      1.042301,
      1.384017,
      0.664122,
      0,
      0.009450,
      NULL,
      0.074621,
      0.151066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '32030',
      NULL,
      '',
      1.158249,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


